;#pragma usePoFile 0
;La instruccin anterior es para que el script sea compatible con versiones anteriores a Jaws 17


Globals
	;Variable booleana que indica si la voz estaba activada al entrar en la aplicacin
	int bAutostartSpeechOn


Void Function AutoStartEvent ()

   ; Si la voz ya est desactivada slo se guarda esa informacin para luego restaurar la voz
	if (IsSpeechOff ()) 
	then	
			let bAutostartSpeechOn= 0
			return;
	endif
	
   ;Causes the synthesizer to be muted
	SpeechOff ()

	; Se guarda informacin para saber que la voz estaba activada al entrar
	let bAutostartSpeechOn= 1

EndFunction


Void Function AutoFinishEvent ()
;Put code here that will be triggered when the application is finished.
;It also gets performed when the application is switched from or looses focus, as with ALT+TAB.

    ; Se deja la voz como estaba al entrar en la aplicacin

	; Si la voz estaba activada y ahora est desactivada, se activa
	if  ( (bAutostartSpeechOn==1) &&  IsSpeechOff() )
	then
		; UnMutes the synthesizer
		SpeechOn()
		return;
	endif

	; Si la voz estaba desactivada y ahora est activada, se desactiva
	if ( (bAutostartSpeechOn==0) && !IsSpeechOff())
	then
		SpeechOff()
	endif

EndFunction

; Activa / desactiva la voz
; Aviso: si Jaws est ejecutndose con la opcin "Ejecutar Jaws sin voz", la voz no puede activarse por script.
Script ActivarVoz ()

	if (IsSpeechOff ()) 
		SpeechOn()
		SayString("Voz activada")
	else
		SayString("Voz desactivada")
		SpeechOff()
	Endif

EndScript