;#pragma usePoFile 0
;La instruccin anterior es para que el script sea compatible con versiones anteriores a Jaws 17
; El script se sobreescribe la funcin "FocusChangedEventProcessAncestors"  
; pero se ha comprobado que en Jaws 16, 17 y 18 el cdigo
;de la funcin era el mismo

; -------------------------------------------------------------------------------------------------------------------------------------------------------
; Funcionalidad:
;  Script Control+W: activa y desactiva la voz de Jaws
;  - Al entrar en la aplicacin se desactiva la voz de Jaws si estaba activida. Al salir de la aplicacin
;    se deja Jaws con la voz como la tuviera (activada o desactivada)
; - Se sobreescribe la funcin "FocusChangedEventProcessAncestors" para:
;         1) Si recibe el foco el control de tipo "TextControl", de forma automtica se lee todo el texto
;             (si no se hace, cuando coge el foco lee slo una cierta cantidad de texto)
;         2) Si recibe el foco el botn con name "Actividad siguiente" o "Actividad anterior" se provoca
;             que slo lea el nombre del botn. Si no se hace, hay muchos momentos en que lee el ttulo
; 			    de la actividad
; -------------------------------------------------------------------------------------------------------------------------------------------------------

; Includes necesarios para "FocusChangedEventProcessAncestors"
Include "HjGlobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
Include "common.jsm" ; message file


Const
	; Class name de TextControl
	TEXTCONTROL_CLASSNAME = "tx23",	

	; Nombre de los botones "Actividad siguiente" y "Actividad anterior"
	ACTNEXT_BTNAME = "actividad siguiente",
	ACTPREV_BTNAME = "actividad anterior"



Globals
	;Variable booleana que indica si la voz estaba activada al entrar en la aplicacin
	int bAutostartSpeechOn


Void Function AutoStartEvent ()

   ; Si la voz ya est desactivada slo se guarda esa informacin para luego restaurar la voz
	if (IsSpeechOff ()) 
	then	
			let bAutostartSpeechOn= 0
			return;
	endif
	
   ;Causes the synthesizer to be muted
	SpeechOff ()

	; Se guarda informacin para saber que la voz estaba activada al entrar
	let bAutostartSpeechOn= 1

EndFunction


Void Function AutoFinishEvent ()
;Put code here that will be triggered when the application is finished.
;It also gets performed when the application is switched from or looses focus, as with ALT+TAB.

    ; Se deja la voz como estaba al entrar en la aplicacin

	; Si la voz estaba activada y ahora est desactivada, se activa
	if  ( (bAutostartSpeechOn==1) &&  IsSpeechOff() )
	then
		; UnMutes the synthesizer
		SpeechOn()
		return;
	endif

	; Si la voz estaba desactivada y ahora est activada, se desactiva
	if ( (bAutostartSpeechOn==0) && !IsSpeechOff())
	then
		SpeechOff()
	endif

EndFunction


; Activa / desactiva la voz
; Aviso: si Jaws est ejecutndose con la opcin "Ejecutar Jaws sin voz", la voz no puede activarse por script.
Script ActivarVoz ()

	if (IsSpeechOff ()) 
		SpeechOn()
		SayString("Voz activada")
	else
		SayString("Voz desactivada")
		SpeechOff()
	Endif


EndScript


; 

Void Function FocusChangedEventProcessAncestors (handle FocusWindow, handle PrevWindow)
var
	int nLevel,
	int iType,
	string sClassName,
	string sName

let nLevel = GetFocusChangeDepth()

; -------------------------------------------------------------------------------------------------------------------------------------------------
; INICIO CDIGO PROPIO APLICACIN

	let sClassName= StringLower(getWindowClass(FocusWindow))

	; Si el objeto que recibe el foco es un TextControl, se lee de forma automtica todo el contenido
	; Si no se hace as, Jaws slo lee una parte del contenido

	if (StringContains(sClassName, TEXTCONTROL_CLASSNAME )!=0) then
		SayAll()
		return
	else 

		; si el foco lo reciben los botones "Actividad anterior" o "Actividad siguiente", se asigna nLevel 0 
		; Si no se hace as, Jaws lee en uno de los dos botones el ttulo de la actividad cada vez que el botn recibe el foco (adems de leer el botn).
		; Lo hace as porque, por algn motivo, "nLevel" tiene valor 2 en lugar de 0

		let sName= StringLower (getObjectName())
		if ( (StringContains(sName, ACTNEXT_BTNAME )!=0) || (StringContains(sName, ACTPREV_BTNAME )!=0)  )then
			let nLevel = 0
		endif
	endif
; FIN CDIGO PROPIO APLICACIN
; -------------------------------------------------------------------------------------------------------------------------------------------------

; CONTINUACIN CDIGO ORIGINAL SCRIPT DEFAULT.JSS (Jaws 17.0.2727)
while (nLevel >= 0)
	iType = GetObjectSubtypecode(true,nLevel)
	if nLevel < 2
	&& iType == WT_TABLECELL then
		if globalSpeakHeaderOnCellChange == TABLE_NAV_HORIZONTAL then
			Say(GetColumnHeader(TRUE),OT_SCREEN_MESSAGE)
		elif globalSpeakHeaderOnCellChange == TABLE_NAV_VERTICAL then
			Say(GetRowHeader(TRUE),OT_SCREEN_MESSAGE)
		EndIf
	EndIf
	if globalRibbonState
	&& nLevel > 1
		;What we want is only control group info, not extraneous combo and other info.
		;This is so User knows when we move to new group,
		;but sans the extra chatter.
		if (iType == WT_TOOLBAR ||iType == WT_GROUPBOX)
			sayObjectTypeAndText(nLevel)
		endIf
		elif ( nLevel == 0
		&& iType == wt_groupbox
		&& GetObjectSubTypeCode( true, nLevel + 1 ) == wt_listview )
	SayControlEx( 0, GetObjectName( true ), cmsgGrouping );
	else		
		sayObjectTypeAndText(nLevel)
	EndIf
	let nLevel= nLevel-1
EndWhile

EndFunction






